--
--
--
function getTrainingGroups()
	local log_id = "_training_facility_"
	local masters = nil
	local pupils = nil
	local hired_mercs = getHiredMercs(true)
	
	local getMastersAndPupils = function(index, name)
		local squad = getMercSquad(name)
		local assignment = getPersonAssignment(name)
		
		log(log_id, "getTrainingGroups:", squad, name, assignment)
		
		if (assignment == "trainer_str") then
			log(log_id, "getTrainingGroups:", name, "is Master")
		
			if (masters == nil) then
				masters = {}
			end
			
			masters[squad] = name
			
		elseif (assignment == "student_str") then
			
			if (pupils == nil) then
				pupils = {}
				pupils[squad] = {}
			elseif (pupils[squad] == nil) then
				pupils[squad] = {}
			end
			
			table.insert(pupils[squad], name)
			
			log(log_id, "getTrainingGroups:", name, "is Pupil")
		end
	end
	
	table.foreach(hired_mercs, getMastersAndPupils)
	
	return  masters, pupils
end
--
function getMasterTopSkills(master)
	local skills = 
					{
						DEXTERITY = getParameter(master, "DEXTERITY", false),
						AGILITY = getParameter(master, "AGILITY", false),
						STRENGTH = getParameter(master, "STRENGTH", false),
--						LEADERSHIP = getParameter(master, "LEADERSHIP", false),
						MARKSMANSHIP = getParameter(master, "MARKSMANSHIP", false),
						MECHANICAL = getParameter(master, "MECHANICAL", false),
						MEDICAL = getParameter(master, "MEDICAL", false),
						EXPLOSIVES = getParameter(master, "EXPLOSIVES", false)
					}
	
	local topSkills = nil
	
	local function getTopSkills(skill, value)
		if (value >= 80) then
		
			if (topSkills == nil) then
				topSkills = {}
			end
			
			topSkills[skill] = value
		end
	end
	
	table.foreach(skills, getTopSkills)
	
	return topSkills
end
--
function iWannaBeJedi()
	
	local log_id = "_training_facility_"
	
	log(log_id, ">>>>>>>>>>>>>>>ENTRANCE<<<<<<<<<<<<<<<")
	
	local m, p = getTrainingGroups()
	local groups = nil
	
	if ((m == nil) or (p == nil)) then
		log(log_id, "No masters or pupils")
		return
	else
		log(log_id, "OK1")
	end
	
	local checkGroups = function(squad, master)
		if (p[squad] ~= nil) then
			
			if (groups == nil) then
				groups = {}
				groups[squad] = {}
			elseif (groups[squad] == nil) then
				groups[squad] = {}
			end
			
			groups[squad].master = master
			groups[squad].pupils = p[squad]
		end
	end
	
	table.foreach(m, checkGroups)
	
	if (groups == nil) then
		log(log_id, "No complete groups")
		return
	else
		log(log_id, "OK2")
	end
	
	local trainThem = function(squad, group)
		local master = group.master
		local pupils = group.pupils
		local masterTopSkills = getMasterTopSkills(master)
		local hasTeachSkill1 = (string.upper(getPersonParameterStr(master,"SKILL1"))=="TEACHING")
		local hasTeachSkill2 = (string.upper(getPersonParameterStr(master,"SKILL2"))=="TEACHING")
		local leadership = getPersonParameter(master, "LEADERSHIP")
		
		if (masterTopSkills ~= nil) then
			
			local apply = function(index, pupil)
				log(log_id, "> Master:", master, "Pupil:", pupil)
				
				local selectSkill = function(skill, masterSkillValue)
					local pupilSkillValue = getParameter(pupil, skill, false)

					log(log_id, ">> Skill:", skill, "Master's value:", masterSkillValue, "Pupil's value:", pupilSkillValue, (pupilSkillValue / masterSkillValue))
					
					if (math.random() > (pupilSkillValue / masterSkillValue)) then 
						local baseChances = 5 + masterSkillValue - 80
						baseChances = baseChances*(leadership/60)
						if(hasTeachSkill1) then
							baseChances = baseChances*1.25
						end
						if(hasTeachSkill2) then
							baseChances = baseChances*1.25
						end

						local chances = 0
						
						if (pupilSkillValue < 85) then
							chances = baseChances + 85 - pupilSkillValue
							
							log(log_id, ">>> base throws:", baseChances)
							log(log_id, ">>> total throws:", chances)
							log(log_id, ">>> dicing!")
							
							processStatChange(pupil, calcDiceRoll(chances), skill)
							processStatChange(master, calcDiceRoll(1), skill)
							--processStatChange(master, calcDiceRoll(1), "WISDOM")
							--processStatChange(master, calcDiceRoll(1), "LEVEL")
							processStatChange(master, calcDiceRoll(10), "LEADERSHIP")
	
						else
							log(log_id, ">>> Already at 85, no training possible. Go practice!")
						end
					else
						log(log_id, ">>> No gain with time")
					end
					
				end
				
				table.foreach(masterTopSkills, selectSkill)
			end
			
			local squad_num = getMercSquad(master)
			local isMoving = SQUAD_IS_MOVING["squad"..squad_num]
			log(log_id, "isMoving", isMoving, "squad", squad_num)
			if ( isMoving ~= true) then
				table.foreach(pupils, apply)
			end
		end
	end
	
	table.foreach(groups, trainThem)
end
--
